unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    procedure FormCreate(Sender: TObject);
    procedure StringGrid1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure StringGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

resourcestring
  sExit='Exit';

var
  // A kivlasztott cella koordinti
  SRow:integer=-1;
  SCol:integer=-1;

procedure TForm1.FormCreate(Sender: TObject);
var
   i,j : Integer;
begin
   with StringGrid1 do
     begin
        // Belltsok
           Options:=Options+[goTabs]-
                    [goRangeSelect];
        // Mretek
        Height:=360;
        Width:=345;
        ColCount:=11;
        RowCount:=11;
        for i:=0 to 10 do
          begin
            colwidths[i]:=30;
            rowheights[i]:=30;
          end;
        //Sznek
        Color:=clYellow;
        FixedColor:=clBlue;
        Font.Color:=clBlue;
        Font.size:=12;
        // A rgztett cellk feltltse
        for i:=1 to 11 do
          begin
            cells[i,0]:=format('%2d',[i]);
            cells[0,i]:=format('%2d',[i]);
          end;
        // A tblzat feltltse
        for i:=1 to 10 do
          for j:=1 to 10 do
            cells[i,j]:=format('%d',[i*j]);
     end;
end;

procedure TForm1.StringGrid1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  Arow, Acol : Integer;
begin
  StringGrid1.MouseToCell(x,y,arow,acol);
    // Kilps a programbl
  if (Arow=0) and (Acol=0) then form1.close;
end;

procedure TForm1.StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
begin
   // [0,0] cella megjelentse
   if (Arow=0) and (ACol=0) then
    begin
      with Stringgrid1.Canvas do
        begin
          Font.Color:=clYellow;
          Font.size:=10;
          Font.style:=[fsBold];
          Brush.Color:=Clred;
          TextRect(Rect,Rect.Left+2,Rect.Top+6,sExit)
        end;
    end;

   // A rgztett cellk megjelentse
   if (gdFixed in State) and (Arow<>Acol) then
     if (Arow=Srow) or (Acol=Scol) then
       // A kivlasztott cella sora, oszlopa
       begin
        with Stringgrid1, Canvas do
          begin
            Font.Color:=clWhite;
            Font.size:=12;
            Brush.Color:=rgb(255,0,128);
            if (Arow=0) then
              TextRect(Rect,Rect.Left,Rect.Top+10,cells[Arow,Acol])
            else
              TextRect(Rect,Rect.Left+10,Rect.Top,cells[Arow,Acol])
          end;
       end
     else
       // Nem a kivlasztott cella sora, oszlopa
       begin
        with Stringgrid1, Canvas do
          begin
            Font.Color:=clWhite;
            Font.size:=12;
            Brush.Color:=ClBlue;
            TextRect(Rect,Rect.Left,Rect.Top,cells[Arow,Acol]);
          end;
       end;

   // A fokuszlt cella megjelentse
   if (gdFocused in State) then
     begin
      with Stringgrid1, Canvas do
        begin
          Font.Color:=clWhite;
          Font.size:=16;
          Font.style:=[fsBold];
          Brush.Color:=rgb(255,0,128);
          TextRect(Rect,Rect.Left+2,Rect.Top+2,cells[Arow,Acol]);
        end;
     end;


end;
procedure TForm1.StringGrid1SelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
  SRow:=Arow;
  SCol:=ACol;
  StringGrid1.Invalidate;
end;

end.
